      program covfft
c ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                       c o v f f t
c
c  program for computing covariance functions, power spectra,
c  and potential degree variances for gridded gravity data
c  by fft. power spectrum will be given in units of
c  mgal**2*degree**2, and expressed in db (10log10).
c  the program also outputs anisotropy index and slope of
c  of power spectrum
c
c  input:
c
c  gridfile 
c  covtxt
c  covgrid
c  
c  rfi1, rla1, inn, ine, iwndow
c
c  where
c
c  gridfile  name of grid file containing data grid in tc-format.
c            the data must be stored in free format as scan lines
c            from w to e, starting from n. the grid must be initia-
c            ted by a label (la1,lat2,lon1,lon2,dlat,dlon) defining
c            grid boundaries.
c            only a subgrid on the data grid may be analyzed.
c  covtxt    outputpfile
c  covgrid   outputfile for 2-d covariance function grid
c
c  rfi1, rla1  sw corner of wanted subgrid (degrees)
c  inn, ine    number of points of subgrid (should be even numbers)
c  iwndow      width of cosine-tapered window zone in grid points
c
c  rf, may 1986. based on osu program cov, december 1983.
c
c cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision(a-h,o-z)
      dimension hlab(9), dname(2), oname(2), cname(2)
      dimension nnarr(2)
      dimension hh(500)
      logical lgeog, lrun2
      character*72 gridfile,covtxt,covgrid
c
c  fixed array bounds   ihadim = 160 x 160 = 25,600
c  ipwdim = 160/2 + 1 = 81
c  iwkdim = 160*2 = 320
c  (larger area modification:
c  ihadim = 216 x 192 = 41,472)
c
      dimension cha(2, 2000000)
      dimension wrk(     3600)
      dimension pw(2200),ipw(2200),cf(2200),icf(2200),sigma(2200)
      dimension wf(300)
      idim = 2000000
      iwkdim = 3600
      ipwdim = 2200
      idim2 = 2*idim
      rewind(20)
c
      radeg = 180/3.14159265
c
      write(*,4)
4     format(' --- COVFFT ---'/,
     .' input file names: gridfile/covtxt/covgrid')
      read(*,'(a)') gridfile
      read(*,'(a)') covtxt
      read(*,'(a)') covgrid
      open(20,file=gridfile)
      open(30,file=covtxt,status='unknown')
      open(32,file=covgrid,status='unknown')
      open(31,status='scratch',form='unformatted')
c
      write(*,5)
5     format(' input: rfisw, rlonsw, inn, ine, iwndow')
      read(*,*) rfic,rlac,inn,ine,iwndow
c
      write(*, 10) rfic, rlac, inn, ine, iwndow
10    format(/' --- covfft - gravity covariance analysis by fft ---',
     */' wanted sw corner:',2f9.4, ', points:',2i4,
     *', iwndow:',i3)
c
c  read gridded gravity values
c  ----------------------------
c
c  subroutine for reading a digital grid file on
c  standard format, i.e. stored rowwise from nw to se, with label.
c
c  as se-corner coordinate 'rfic, rlac' (radians) will be used
c  (unless they are zero, then the grid corner is used).
c  a grid containing 'inn' x 'ine' points will be put in array
c  'iha' of declared dimension 'ihadim'.
c  if inn=0 the complete grid will be read.
c
c  initialize statistics
c
      hsum = 0.0
      hsum2 = 0.0
      hmin = 99999
      hmax = -99999
c
c  read label on gravity grid
c
      read(20,*) (hlab(ii),ii=4,9)
      nn = (hlab(5)-hlab(4))/hlab(8)+1.5
      ne = (hlab(7)-hlab(6))/hlab(9)+1.5
      n = nn*ne
c
c  find corner indices for wanted subgrid
c
      dfi = hlab(8)
      dla = hlab(9)
      if (inn.eq.0) goto 113
      if (.not.(rfic.eq.0.and.rlac.eq.0)) goto 114
        rfic = hlab(4)
        rlac = hlab(6)
114   ifi1 = (rfic-hlab(4))/dfi+1.5
      ila1 = (rlac-hlab(6))/dla+1.5
      ifi2 = ifi1+inn-1
      ila2 = ila1+ine-1
      rfic = (ifi1-1)*dfi + hlab(4)
      rlac = (ila1-1)*dla + hlab(6)
      goto 115
c
113   ifi1 = 1
      ila1 = 1
      ifi2 = nn
      ila2 = ne
      inn = nn
      ine = ne
      rfic = hlab(4)
      rlac = hlab(6)
c
c  check boundaries and array size
c
115   n = inn*ine
      if (1.le.ifi1.and.ifi2.le.nn.and.1.le.ila1.and.
     .ila2.le.ne) goto 121
      write(6, 119) nn,ne,ifi1,ifi2,ila1,ila2
119   format(' *** warning: wanted area too large',
     .6i4)
      stop 'sorry'
121   continue
      if (n.le.idim) goto 123
      write(6, 122) n,idim
122   format(' *** h array size too small - wanted, declared ',2i7)
      stop 'sorry'
123   continue
c
c  read given data grid
c
      do 130 i = nn,1,-1
        read(20,*) (hh(j),j=1,ne)
        do 130 j = 1,ne
        r = hh(j)
        if (i.lt.ifi1.or.i.gt.ifi2) goto 130
        if (j.lt.ila1.or.j.gt.ila2) goto 130
        ii = (ifi2-i)*ine + j-ila1+1
        cha(1,ii) = r
130   continue
c
      do 135 ii = 1,n
        h = cha(1,ii)
        if (h.gt.hmax) hmax = h
        if (h.lt.hmin) hmin = h
        hsum = hsum + h
        hsum2 = hsum2 + h**2
135   continue
c
c  write information and statistics
c
      rfi = hlab(4) + (ifi1-1)*hlab(8)
      rla = hlab(6) + (ila1-1)*hlab(9)
      n=inn*ine
      r = hsum/n
      s = 0.0
      if (n.gt.1)
     .s = sqrt((hsum2 - hsum**2/n)/(n-1))
      write(6,141) (hlab(j),j=4,7),hlab(8)*60,hlab(9)*60
141   format(' input grid: ', 4f10.4,2f7.2)
      ii=ii-1
      write(6, 143) rfi, rla, inn, ine, ii
143   format(' selected: sw corner ',2f10.4, ', points ', 3i6 )
      write(6, 144) hmin, hmax, r, s
144   format(' statistics: min max mean std.dev. ',4f9.2)
c
c  set fft constants, check dimension, find mean
c  ----------------------------------------------
c
      n = inn * ine
      nnarr(1) = ine
      nnarr(2) = inn
      nyqn = inn/2 + 1
      nyqe = ine/2 + 1
      if (n.le.idim) goto 17
      write(6, 16) n, idim
16    format(' *** array size too small: wanted, declared ',2i7)
      stop
c
17    dlacos = dla * cos((rfic+inn/2*dfi)/radeg)
      dydx = dfi/dlacos
      s = 0.0
      do 18 i = 1, n
        s = s + cha(1,i)
18    continue
      rmean = s/n
c
      s = 0.0
      do 21 i = 1, n
        cha(1,i) = cha(1,i) - rmean
        cha(2,i) = 0.0
        s = s + cha(1,i)**2
21    continue
      s = s/n
      write(6, 24) s, rmean
24    format( ' power space domain ',f10.2,', mean ',f9.2)
c
c  windowing of data grid
c
      if (iwndow.le.0) goto 50
      do 38 i = 1, iwndow
38    wf(i) = (1 - cos(3.14159265*i/(iwndow+1)))/2
      write(6,777) (wf(i),i=1,iwndow)
777   format(' ',12f8.4)
       wsum = 0
       k = 0
       sw = 0.0
       do 40 i = inn, 1, -1
       do 40 j = 1, ine
         k = k+1
         w = 1.0
         if (i.gt.iwndow) goto 41
           w = w*wf(i)
41       if (i.le.inn-iwndow) goto 42
           w = w*wf(inn-i+1)
42       if (j.gt.iwndow) goto 43
           w = w*wf(j)
43       if (j.le.ine-iwndow) goto 44
           w = w*wf(ine-j+1)
44       wsum = wsum + w
         cha(1,k) = cha(1,k)*w
         sw = sw + cha(1,k)**2
40     continue
       wsum = wsum/n
       sw = sw/n
       write(6,48) sw, wsum
48     format(' power after window ',f10.2,', wsum = ', f8.4)
c
c  fourier transformation of elevations
c  ------------------------------------
c  discriminate between complex (j=1) and real (j=0) data
c
50    j = 0
      if (n.le.60) call cprint(cha,idim,inn,ine)
      call fourt(cha,nnarr,2,-1,j,wrk,idim2,iwkdim)
      if (n.le.60) call cprint(cha,idim,inn,ine)
c
c  scale spectrum to account for lost power by windowing
c
      if (iwndow.le.0) sw = s
      r = sqrt(sw/s)
      s = 0
      do 53 i = 1,n
        cha(1,i) = cha(1,i)/n/r
        cha(2,i) = cha(2,i)/n/r
        s = s + cha(1,i)**2 + cha(2,i)**2
53    continue
      write(6, 54) s
54    format(' power freq. domain ',f10.2)
c
c  power spectrum and covariance functions
c  ---------------------------------------
c
      do 51 i=1,n
        cha(1,i) = cha(1,i)**2 + cha(2,i)**2
        cha(2,i) = 0.0
51    continue
c
      r = ine/(dydx*inn)
      call azsmoo(cha,idim,inn,ine,r,
     .pw,ipw,ipwdim)
c
      call fourt(cha,nnarr,2,1,1,wrk,idim2,iwkdim)
      call azsmoo(cha,idim,inn,ine,
     .dydx,cf,icf,ipwdim)
c     if (n.le.60) call cprint(cha,idim,inn,ine)
c
c  center covariance function
c
      ishift = (inn-1)/2+1
      jshift = (ine-1)/2
      do 70 ii = 1, inn
      do 70 jj = 1, ine
        i = ii + ishift+1
        j = jj + jshift+1
        if (i.gt.inn) i = i-inn
        if (j.gt.ine) j = j-ine
        r = cha(1,(i-1)*ine+j)
        write(31) r
70    continue
      rewind(31)
      do 71 ii = inn,1,-1
      do 71 jj = 1,ine
71    read(31) cha(1,(ii-1)*ine+jj)
      rewind(31)

c
c  print out covariance function and power spectra
c  ------------------------------------------------
c  power spectra given as logaritmic gravity effect
c
      c0 = cf(1)
      gpwr = 0.0
      pfakt = inn*dfi*ine*dlacos
      pw(1) = pw(1) + rmean**2
      sigma(1) = 999.9
      sifakt = 360.0/(dfi*inn)
      do 56 i = 1,nyqn
        pw(i) = pfakt*pw(i)
        l = (i-1)*sifakt+.5
        if (i.gt.1) sigma(i) = 5.025e-17*(l+.5)/(1.0*(l-1))**2*pw(i)
        if (i.gt.1) gpwr = gpwr + sigma(i)
        if (pw(i).le.0) pw(i) = 9.d39
        if (sigma(i).le.0) sigma(i) = 9.d39
        pw(i) = 10*.4342945*log(1.0d0*pw(i))
        if (i.gt.1) sigma(i) = .4342945*log(1.d0*sigma(i))
56    continue
      gpwr = gpwr*sifakt*4.055e13
c
c  correlation length and anisotropy
c  azimuth positive from north towards east
c
      chalf = c0/2
      do 201 i = 2, nyqn
201   if (cf(i).lt.chalf) goto 202
      xhalf = 999.9
      goto 203
202   xhalf = ((cf(i-1)-chalf)/(cf(i-1)-cf(i)) + i-2)*dfi*60
c
c  for anisotropy index divide 180 degrees in 'nang' segments.
c
203   nang = 36
      xhmin = 999.9
      xhmax = -999.9
      thmax = 999.9
      do 210 k=1,nang
        theta = 3.14159265*(k-1)/nang
        costh = cos(theta)
        sinth = sin(theta)
        theta = 90.0 - theta*radeg
        rp = cf(1)
        do 211 i=2,nyqn
          rx = (i-1)*costh*dydx  + 2 + jshift
          ry = (i-1)*sinth  + 1 + ishift
          if (rx.lt.1.or.rx.gt.ine) goto 212
          if (ry.gt.inn) goto 212
          r = bilinc(ry,rx,cha,idim,inn,ine,1)
c       write(6,702) i,ry,rx,r/c0
c702    format(' i,ry,rx,r=',i4,3f8.3)
          if (r.lt.chalf) goto 213
          rp = r
211     continue
212     aniso = 999.9
        thmax = 999.0
        goto 215
213     xh = ((rp-chalf)/(rp-r)+ i-2)*dfi*60
c      write(6,220) k,theta,xh
c220   format(' k,theta,xh= ',i4,f7.0,f9.2)
        if (xh.lt.xhmin) xhmin = xh
        if (xh.gt.xhmax) thmax = theta
        if (xh.gt.xhmax) xhmax = xh
210   continue
215   aniso = xhmax/xhmin
c
c  find slope of degree variance spectrum
c
      lmin = 181
      np = 0
      sx = .0
      sy = .0
      sxy = .0
      sx2 = .0
      do 250 i = 2,nyqn
        l = (i-1)*sifakt+.5
        if (l.lt.lmin) goto 250
        xl = .4342945*log(1.d0*l)
        yl = sigma(i)
        np = np+1
        sx = sx + xl
        sy = sy + yl
        sxy = sxy + xl*yl
        sx2 = sx2 + xl**2
250   continue
      if (np.le.1) slp = 999.0
      if (np.gt.1) slp = (sxy-sx*sy/np)/(sx2-sx**2/np)
c
      write(6, 58) c0,sqrt(c0),xhalf,aniso,thmax,slp,gpwr
58    format(/' characteristic covariance parameters:'/
     *' c0, rms = = ',2f8.2,', xhalf (arcmin) = ',f6.1/
     *' anisotopy index and direction = ',f5.1,f5.0,
     */' sigma slope = ',f5.1,', geoid variance = ',f9.2)
      write(6, 59) dfi*60, 1/(inn*dfi)
59    format(/' spacing ',f8.3,' arcmin, freq.spacing. ',
     .f8.4,' cycles/degree')
c
      write(6, 60) nyqn
60    format(' points',i4,/,/,
     .' <   n    psi    l      power(db)         cov         sigma')
      do 62 i = 1, nyqn
        l = (i-1)*sifakt+.5
        write(6, 61) i-1, (i-1)*dfi*60, l, pw(i),
     .  cf(i)/c0, sigma(i), icf(i)
61      format(i6,f7.2,i5,3f14.4,i8)
62    continue
c
c  output data on ofile for plotning
c
      write(30,80)
80    format(/' power spectrum ')
      do 81 i=1,nyqn
81    write(30,82) (i-1)/(dfi*inn), pw(i)
82    format(1x,f8.2,f12.2)
      write(30,83)
83    format(/' covariance function')
      do 84 i=1,nyqn
84    write(30,82) (i-1)*dfi*60, cf(i)
      write(30,86)
86    format(/' degree variances')
      do 87 i=2,nyqn
87    write(30,82) .4342945*log((i-1)*sifakt),sigma(i)
c
c  write out contents of cha(1,.) on cfil
c
      write(32,900) rfic,rfic+(inn-1)*dfi,
     *rlac,rlac+(ine-1)*dla,dfi,dla
900   format(' ',4f12.6,2f12.8/)
      do 910 ii=inn,1,-1
910   write(32,912) (cha(1,(ii-1)*ine+jj)/c0,jj=1,ine)
912   format(' ',9f8.3)
c
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                    c p r i n t
c
c  prints the contents of complex array cha
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine cprint(cha, ihadim, inn, ine)
      implicit double precision(a-h,o-z) 
      dimension cha(2,ihadim)
      do 19 k=1,2
        j1=1
        j2=ine
        write(6,11)
11      format(' ')
        do 18 i=inn,1,-1
          write(6,12) (cha(k,j),j=j1,j2)
12        format(8f11.4)
          j1 = j1+ine
          j2 = j2+ine
18      continue
19    continue
      return
      end
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                   a z s m o o
c
c  averages power spectrum or covariance function in circles
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine azsmoo(cha,ihadim,inn,ine,
     .                  dydx,cf,icf,icfdim)
      implicit double precision(a-h,o-z)
      dimension cha(2,ihadim)
      dimension icf(icfdim), cf(icfdim)
      nyqn = inn/2+1
      nyqe = ine/2+1
      do 10 i = 1, nyqn
        cf(i) = 0.0
        icf(i) = 0
10    continue
c
      do 18 i = 1, nyqn
      do 18 j = 1, nyqe
        ii = inn+2-i
        jj = ine+2-j
        k11 = (i-1)*ine+j
        k12 = (i-1)*ine+jj
        k21 = (ii-1)*ine+j
        k22 = (ii-1)*ine+jj
        r = sqrt((i-1.0)**2 + ((j-1)/dydx)**2)
        k = r+0.5 + 1
        if (k.gt.nyqn) goto 17
c
        if (i.gt.1.or.j.gt.1) goto 11
        cf(k) = cf(k) + cha(1,k11)
        icf(k) = icf(k)  + 1
        goto 17
11      if (i.gt.1) goto 12
        cf(k) = cf(k) + cha(1,k11) + cha(1,k12)
        icf(k) = icf(k) + 2
        goto 17
12      if (j.gt.1) goto 13
        cf(k) = cf(k) + cha(1,k11) + cha(1,k21)
        icf(k) = icf(k) + 2
        goto 17
13      cf(k) = cf(k) + cha(1,k11) + cha(1,k21) +
     .                  cha(1,k12) + cha(1,k22)
        icf(k) = icf(k) + 4
17      continue
18    continue
      do 19 i = 1,nyqn
        cf(i) = cf(i)/icf(i)
19    continue
      return
      end
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                     b i l i n c
c
c  interpolates values in a dtm array using bilinear
c  (parabolic hyperboloid) interpolation
c  argument ri, rj has (1,1) in lower left corner.
c
c  rf, june 84
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      real*8 function bilinc(ri, rj, cha, ihadim, imax, jmax, kk)
      implicit double precision(a-h,o-z)
      dimension cha(2, ihadim)
      in = ri
      ie = rj
      rn = ri - in
      re = rj - ie
      if (in.ge.1) goto 10
      in = 1
      rn = 0.0
10    if (in.lt.imax) goto 11
      in = imax-1
      rn = 1.0
11    if (ie.ge.1) goto 12
      ie = 1
      re = 0.0
12    if (ie.lt.jmax) goto 13
      ie = jmax-1
      re = 1.0
13    k = (in-1)*jmax+ie
      ku = k+jmax
      r = (1-rn)*(1-re)*cha(kk,k) +
     .rn*(1-re)*cha(kk,ku) + (1-rn)*re*cha(kk,k+1) +
     .rn*re*cha(kk,ku+1)
      bilinc = r
      return
      end
c
      subroutine fourt(datt,nn,ndim,isign,iform,work,
     .idim1,idim2)
      implicit double precision(a-h,o-z)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                     f o u r t
c
c        version=740301
c        program description norsar n-pd9 dated 1 july 1970
c        author n m brenner
c        further description    three fortran programs etc.
c        issued by lincoln laboratory, mit, july 1967
c        two corrections by hjortenberg 1974
c     the fast fourier transform in usasi basic fortran
c
c     modified to rc fortran rf june 84
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      dimension datt(idim1),nn(ndim),ifact(32),work(idim2)
c
      np0=0
      nprev=0
c
      twopi=6.283185307
      rthlf=.7071067812
      if(ndim-1)920,1,1
1     ntot=2
      do 2 idim=1,ndim
      if(nn(idim))920,920,2
2     ntot=ntot*nn(idim)
c
c     mainloop for each dimension
c
      np1=2
      do 910 idim=1,ndim
      n=nn(idim)
      np2=np1*n
      if(n-1)920,900,5
c
c     is n a power of two and if not, what are its factors
c
5     m=n
      ntwo=np1
      if=1
      idiv=2
10    iquot=m/idiv
      irem=m-idiv*iquot
      if(iquot-idiv)50,11,11
11    if(irem)20,12,20
12    ntwo=ntwo+ntwo
      ifact(if)=idiv
      if=if+1
      m=iquot
      go to 10
20    idiv=3
      inon2=if
30    iquot=m/idiv
      irem=m-idiv*iquot
      if(iquot-idiv)60,31,31
31    if(irem)40,32,40
32    ifact(if)=idiv
      if=if+1
      m=iquot
      go to 30
40    idiv=idiv+2
      go to 30
50    inon2=if
      if(irem)60,51,60
51    ntwo=ntwo+ntwo
      go to 70
60    ifact(if)=m
70    non2p=np2/ntwo
c
c     separate four cases---
c        1. complex transform
c        2. real transform for the 2nd, 3nd, etc. dimension.  method--
c           transform half the datt, supplying the other half by con-
c           jugate symmetry.
c        3. real transform for the 1st dimension,n odd.  method--
c           set the imaginary parts to zero
c        4. real transform for the 1st dimension,n even.method--
c           transform a complex array of lenght n/2 whose real parts
c           are the even numberd real values and whose imaginary parts
c           are the odd numberedreal values.  separate and supply
c           the second half by conjugate summetry.
c
      icase=1
      ifmin=1
      i1rng=np1
      if(idim-4)74,100,100
74    if(iform)71,71,100
71    icase=2
      i1rng=np0*(1+nprev/2)
      if(idim-1)72,72,100
72    icase=3
      i1rng=np1
      if(ntwo-np1)100,100,73
73    icase=4
      ifmin=2
      ntwo=ntwo/2
      n=n/2
      np2=np2/2
      ntot=ntot/2
      i=1
      do 80 j=1,ntot
      datt(j)=datt(i)
80    i=i+2
c
c     shuffle datt by bit reversal, since n=2**k.  as the shuffling
c     can be done by simple interchange, no working array is needed
c
100   if(non2p-1)101,101,200
101   np2hf=np2/2
      j=1
      do 150 i2=1,np2,np1
      if(j-i2)121,130,130
121   i1max=i2+np1-2
      do 125 i1=i2,i1max,2
      do 125 i3=i1,ntot,np2
      j3=j+i3-i2
      tempr=datt(i3)
      tempi=datt(i3+1)
      datt(i3)=datt(j3)
      datt(i3+1)=datt(j3+1)
      datt(j3)=tempr
125   datt(j3+1)=tempi
130   m=np2hf
140   if(j-m)150,150,141
141   j=j-m
      m=m/2
      if(m-np1)150,140,140
150   j=j+m
      go to 300
c
c     shuffle datt by digit reversal for general n
c
200   nwork=2*n
      do 270 i1=1,np1,2
      do 270 i3=i1,ntot,np2
      j=i3
      do 260 i=1,nwork,2
      if(icase-3)210,220,210
210   work(i)=datt(j)
      work(i+1)=datt(j+1)
      go to 240
220   work(i)=datt(j)
      work(i+1)=0.
240   ifp2=np2
      if=ifmin
250   ifp1=ifp2/ifact(if)
      j=j+ifp1
      if(j-i3-ifp2)260,255,255
255   j=j-ifp2
      ifp2=ifp1
      if=if+1
      if(ifp2-np1)260,260,250
260   continue
      i2max=i3+np2-np1
      i=1
      do 270 i2=i3,i2max,np1
      datt(i2)=work(i)
      datt(i2+1)=work(i+1)
270   i=i+2
c
c     main loop for factors of two
c     w=exp(isign*2*pi*sqrt(-1)*m/(4*mmax)).  check for w=isign*sqrt(-1)
c     and repeat for w=w*(1+isign*sqrt(-1))/sqrt(2)
c
300   if(ntwo-np1)600,600,305
305   np1tw=np1+np1
      ipar=ntwo/np1
310   if(ipar-2)350,330,320
320   ipar=ipar/4
      go to 310
330   do 340 i1=1,i1rng,2
      do 340 k1=i1,ntot,np1tw
      k2=k1+np1
      tempr=datt(k2)
      tempi=datt(k2+1)
      datt(k2)=datt(k1)-tempr
      datt(k2+1)=datt(k1+1)-tempi
      datt(k1)=datt(k1)+tempr
340   datt(k1+1)=datt(k1+1)+tempi
350   mmax=np1
360   if(mmax-ntwo/2)370,600,600
370   lmax=max0(np1tw,mmax/2)
      do 570 l=np1,lmax,np1tw
      m=l
      if(mmax-np1)420,420,380
380   theta=-twopi*float(l)/float(4*mmax)
      if(isign)400,390,390
390   theta=-theta
400   wr=cos(theta)
      wi=sin(theta)
410   w2r=wr*wr-wi*wi
      w2i=2.*wr*wi
      w3r=w2r*wr-w2i*wi
      w3i=w2r*wi+w2i*wr
420   do 530 i1=1,i1rng,2
      kmin=i1+ipar*m
      if(mmax-np1)430,430,440
430   kmin=i1
440   kdif=ipar*mmax
450   kstep=4*kdif
      if(kstep-ntwo)460,460,530
460   do 520 k1=kmin,ntot,kstep
      k2=k1+kdif
      k3=k2+kdif
      k4=k3+kdif
      if(mmax-np1)470,470,480
470   u1r=datt(k1)+datt(k2)
      u1i=datt(k1+1)+datt(k2+1)
      u2r=datt(k3)+datt(k4)
      u2i=datt(k3+1)+datt(k4+1)
      u3r=datt(k1)-datt(k2)
      u3i=datt(k1+1)-datt(k2+1)
      if(isign)471,472,472
471   u4r=datt(k3+1)-datt(k4+1)
      u4i=datt(k4)-datt(k3)
      go to 510
472   u4r=datt(k4+1)-datt(k3+1)
      u4i=datt(k3)-datt(k4)
      go to 510
480   t2r=w2r*datt(k2)-w2i*datt(k2+1)
      t2i=w2r*datt(k2+1)+w2i*datt(k2)
      t3r=wr*datt(k3)-wi*datt(k3+1)
      t3i=wr*datt(k3+1)+wi*datt(k3)
      t4r=w3r*datt(k4)-w3i*datt(k4+1)
      t4i=w3r*datt(k4+1)+w3i*datt(k4)
      u1r=datt(k1)+t2r
      u1i=datt(k1+1)+t2i
      u2r=t3r+t4r
      u2i=t3i+t4i
      u3r=datt(k1)-t2r
      u3i=datt(k1+1)-t2i
      if(isign)490,500,500
490   u4r=t3i-t4i
      u4i=t4r-t3r
      go to 510
500   u4r=t4i-t3i
      u4i=t3r-t4r
510   datt(k1)=u1r+u2r
      datt(k1+1)=u1i+u2i
      datt(k2)=u3r+u4r
      datt(k2+1)=u3i+u4i
      datt(k3)=u1r-u2r
      datt(k3+1)=u1i-u2i
      datt(k4)=u3r-u4r
520   datt(k4+1)=u3i-u4i
      kdif=kstep
      kmin=4*(kmin-i1)+i1
      go to 450
530   continue
      m=m+lmax
      if(m-mmax)540,540,570
540   if(isign)550,560,560
550   tempr=wr
      wr=(wr+wi)*rthlf
      wi=(wi-tempr)*rthlf
      go to 410
560   tempr=wr
      wr=(wr-wi)*rthlf
      wi=(tempr+wi)*rthlf
      go to 410
570   continue
      ipar=3-ipar
      mmax=mmax+mmax
      go to 360
c
c     main loop for factoers not equal to two
c     w=exp(isign*2*pi*sqrt(-1)*(j1+j2-i3-1)/ifp2)
c
600   if(non2p-1)700,700,601
601   ifp1=ntwo
      if=inon2
610   ifp2=ifact(if)*ifp1
      theta=-twopi/float(ifact(if))
      if(isign)612,611,611
611   theta=-theta
612   wstpr=cos(theta)
      wstpi=sin(theta)
      do 650 j1=1,ifp1,np1
      thetm=-twopi*float(j1-1)/float(ifp2)
      if(isign)614,613,613
613   thetm=-thetm
614   wminr=cos(thetm)
      wmini=sin(thetm)
      i1max=j1+i1rng-2
      do 650 i1=j1,i1max,2
      do 650 i3=i1,ntot,np2
      i=1
      wr=wminr
      wi=wmini
      j2max=i3+ifp2-ifp1
      do 640 j2=i3,j2max,ifp1
      twowr=wr+wr
      j3max=j2+np2-ifp2
      do 630 j3=j2,j3max,ifp2
      jmin=j3-j2+i3
      j=jmin+ifp2-ifp1
      sr=datt(j)
      si=datt(j+1)
      oldsr=0.
      oldsi=0.
      j=j-ifp1
620   stmpr=sr
      stmpi=si
      sr=twowr*sr-oldsr+datt(j)
      si=twowr*si-oldsi+datt(j+1)
      oldsr=stmpr
      oldsi=stmpi
      j=j-ifp1
      if(j-jmin)621,621,620
621   work(i)=wr*sr-wi*si-oldsr+datt(j)
      work(i+1)=wi*sr+wr*si-oldsi+datt(j+1)
630   i=i+2
      wtemp=wr*wstpi
      wr=wr*wstpr-wi*wstpi
640   wi=wi*wstpr+wtemp
      i=1
      do 650 j2=i3,j2max,ifp1
      j3max=j2+np2-ifp2
      do 650 j3=j2,j3max,ifp2
      datt(j3)=work(i)
      datt(j3+1)=work(i+1)
650   i=i+2
      if=if+1
      ifp1=ifp2
      if(ifp1-np2)610,700,700
c
c     complete areal transform in the 1st dimension, n even, by con-
c     jugate symmetries
c
700   go to (900,800,900,701),icase
701   nhalf=n
      n=n+n
      theta=-twopi/float(n)
      if(isign)703,702,702
702   theta=-theta
703   wstpr=cos(theta)
      wstpi=sin(theta)
      wr=wstpr
      wi=wstpi
      imin=3
      jmin=2*nhalf-1
      go to 725
710   j=jmin
      do 720 i=imin,ntot,np2
      sumr=(datt(i)+datt(j))/2.
      sumi=(datt(i+1)+datt(j+1))/2.
      difr=(datt(i)-datt(j))/2.
      difi=(datt(i+1)-datt(j+1))/2.
      tempr=wr*sumi+wi*difr
      tempi=wi*sumi-wr*difr
      datt(i)=sumr+tempr
      datt(i+1)=difi+tempi
      datt(j)=sumr-tempr
      datt(j+1)=-difi+tempi
720   j=j+np2
      imin=imin+2
      jmin=jmin-2
      wtemp=wr*wstpi
      wr=wr*wstpr-wi*wstpi
      wi=wi*wstpr+wtemp
725   if(imin-jmin)710,730,740
730   if(isign)731,740,740
731   do 735 i=imin,ntot,np2
735   datt(i+1)=-datt(i+1)
740   np2=np2+np2
      ntot=ntot+ntot
      j=ntot+1
      imax=ntot/2+1
745   imin=imax-2*nhalf
      i=imin
      go to 755
750   datt(j)=datt(i)
      datt(j+1)=-datt(i+1)
755   i=i+2
      j=j-2
      if(i-imax)750,760,760
760   datt(j)=datt(imin)-datt(imin+1)
      datt(j+1)=0.
      if(i-j)770,780,780
765   datt(j)=datt(i)
      datt(j+1)=datt(i+1)
770   i=i-2
      j=j-2
      if(i-imin)775,775,765
775   datt(j)=datt(imin)+datt(imin+1)
      datt(j+1)=0.
      imax=imin
      go to 745
780   datt(1)=datt(1)+datt(2)
      datt(2)=0.
      go to 900
c
c     complete a real transform for the 2nd, 3rd, etc. dimension by
c     conjugate symmetries.
c
800   if(i1rng-np1)805,900,900
805   do 860 i3=1,ntot,np2
      i2max=i3+np2-np1
      do 860 i2=i3,i2max,np1
      imax=i2+np1-2
      imin=i2+i1rng
      jmax=2*i3+np1-imin
      if(i2-i3)820,820,810
810   jmax=jmax+np2
820   if(idim-2)850,850,830
830   j=jmax+np0
      do 840 i=imin,imax,2
      datt(i)=datt(j)
      datt(i+1)=-datt(j+1)
840   j=j-2
850   j=jmax
      do 860 i=imin,imax,np0
      datt(i)=datt(j)
      datt(i+1)=-datt(j+1)
860   j=j-np0
c
c     end of loop on each dimension
c
900   np0=np1
      np1=np2
910   nprev=n
920   return
      end
