      program gpcol
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                            G P C O L
c
c  program for testing covariance function and least-squares 
c  collocation. a data file (max 'maxobs' pts) is read in and
c  predictions carried out in a grid
c
c  input: sqrtC0, D, T  (covariance parameters, mgal**2 and km)
c         ki1, sig1
c         <ifile1>
c         ki2, sig2
c         <ifile2>
c         -1 -1         (code for end of observations)
c         ko, rlat1, rlat2, rlon1, rlon2, dlat, dlon, h
c         <ofile>
c         <efile>
c
c  ki, ko: input/output type (1:geoid, 3:dg, 6:ksi, 7:eta)
c          deflections given in mgal
c
c  sig:    input data std.dev. If sig = -1 then the std.dev. must
c          be given in the datafile.
c
c  rf, feb 86
c  f77 version sep 1993, updated 2025 with row info
c 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
c
c  dimension: icdim = (maxobs*(maxobs+1))/2+maxobs
c  largest value for Lahey fortran around 8600
c
c     parameter (maxobs=1000,icdim=501500,maxrow=600)
      parameter (maxobs=7200,icdim=25930800,maxrow=2000)
c     parameter (maxobs=8600,icdim=36992900,maxrow=1000) 
      dimension c(icdim),rfi(maxobs),rla(maxobs),h(maxobs)
     .,d(maxobs),csx(maxobs),ki(maxobs),sig2(maxobs)
     .,pred(maxrow),stdv(maxrow)
      equivalence (sig2,csx)
      character*36 ifile, ofile, efile
c
      write(*,*) '--- G P C O L ---'
1     write(*,*) 'input sqrtC0, D, T: '
      read(*,*) sqrtc0,d1,d2
c
      var = sqrtc0**2
      write(*,2) sqrtc0,d1,d2
2     format(' Covariance model: sqrtC0,D,T = ',3f9.2)
c
c  write info on selected planar logarithmic model
c
      write(*,*)
     .'Covariances for gravity and geoid for selected model:'
      write(*,*)
     .'  dist(km)   Cgg (mgal**2)   Cgn (mgal*m)    Cnn (m**2)'
     .,'   Cgg (4 km)'
      ddmin = 9.9d9
      ddmin4 = 9.9d9
      ihalf = -1
      ihalf4 = -1
      do 4 i = 0, 120
        s = i
        cgg = covp(3,3,s,0.d0,0.d0,d1,d2,var)
        cgg4 = covp(3,3,s,0.d0,8000.d0,d1,d2,var)
        if (i.eq.0) var4 = cgg4
        dd = abs(cgg-var/2)
        if (dd.lt.ddmin) then
          ihalf = i
          ddmin = dd
        endif
        dd4 = abs(cgg4-var4/2)
        if (dd4.lt.ddmin4) then
          ihalf4 = i
          ddmin4 = dd4
        endif
        if (mod(i,10).eq.0)
     .  write(*,3) s,cgg,covp(1,3,s,0.d0,0.d0,d1,d2,var),
     .  covp(1,1,s,0.d0,0.d0,d1,d2,var),cgg4
3       format(f9.0,4f15.3)
4     continue
      write(*,*) 'Cgg correlation length: ',ihalf,' km'
      write(*,*) 'Cgg corr. length at 4000 m elev: ',ihalf4,' km'
      write(*,*)
c
c  read observation files
c  ----------------------
c
      sum = 0
      n = 1
c
10    write(*,*) 'input ki,sigma (0 0 = new par, -1 -1 = end obs): '
      read(*,*) kii,sigma
      if (kii.eq.0) goto 1
      if (kii.lt.0) goto 15
      write(*,*) 'input file name: '
      read(*,'(a)') ifile
      write(*,*) '- Reading data from ',ifile
      open(10,file=ifile,status='old')
c
12    if (sigma.ge.0) then
        read(10,*,end=13) ii,rfi(n),rla(n),h(n),d(n)
        sig2(n) = sigma**2
      else
        read(10,*,end=13) ii,rfi(n),rla(n),h(n),d(n),ss
        sig2(n) = ss**2
      endif
      ki(n) = kii
      sum = sum+rfi(n)
      n = n+1
      if (n.gt.maxobs) stop '*** too many observations'
      goto 12
c
13    close(10)
      goto 10
c
15    n = n-1
      if (n.eq.0) stop 'no observations'
      cosfi = cos(sum/n/57.29578d0)
      degkm = 111.11
      coskm = cosfi*degkm
      write(*,*) '- Number of observations input: ',n
c
c  set up collocation equations
c  ----------------------------
c
18    k = 0
      do 20 i = 1,n
      do 20 j = 1,i
        k = k+1
        xx = (rla(i)-rla(j))*coskm
        yy = (rfi(i)-rfi(j))*degkm
        c(k) = covp(ki(i),ki(j),xx,yy,h(i)+h(j),d1,d2,var)
        if (i.eq.j) c(k) = c(k)+sig2(i)
20    continue
      irhs = k
      do 21 i = 1,n
21    c(irhs+i) = d(i)
c
c  solve equations
c  ---------------
c
      call chol(c,n,nsing,1)
      if (nsing.ne.0) write(*,*)
     .'*** warning: singular equations - nsing = ',nsing
      write(*,*)
      write(*,*) '- Collocation equations solved -'
      write(*,*)
      do 23 i = 1, n
23    d(i) = c(irhs+i)
c
c  find predictions
c  ----------------
c
      write(*,*) 'input: kind, gridspec, h + file names ... '

      read(*,*) ko,rfi1,rfi2,rla1,rla2,dfi,dla,hh
      read(*,'(a)') ofile
      read(*,'(a)') efile
      open(20,file=ofile,status='unknown')
      open(21,file=efile,status='unknown')
c
      nfi = (rfi2-rfi1)/dfi + 1.5
      nla = (rla2-rla1)/dla + 1.5
      write(*,24) rfi1,rfi2,rla1,rla2,dfi,dla, nfi,nla
24    format(' output grid: ',4f10.4,2f8.4,i6,i5)
      if (nla.gt.maxrow) stop '*** too many rows - increase maxrow'
c
      write(20,29) rfi1,rfi2,rla1,rla2,dfi,dla
      write(21,29) rfi1,rfi2,rla1,rla2,dfi,dla
29    format(4f12.6,2f12.8)
c
      pmin = 99999.9
      pmax = -99999.9
      np = 0
      do 35 i = nfi,1,-1
      do 30 j = 1, nla
        pfi = rfi1 + (i-1)*dfi
        pla = rla1 + (j-1)*dla
c
c  predictions for point (pfi,pla)
c
        sum = 0
        do 31 k = 1, n
          xx = (rla(k)-pla)*coskm
          yy = (rfi(k)-pfi)*degkm
          cov = covp(ko,ki(k),xx,yy,h(k)+hh,d1,d2,var)
          sum = sum + cov*d(k)
          c(irhs+k) = cov
          csx(k) = cov
31      continue
        pred(j) = sum
c
c  standard deviations
c
        call chol(c,n,info,3)
        sum = 0
        do 32 k = 1, n
32      sum = sum + csx(k)*c(irhs+k)
        sum = covp(ko,ko,0.d0,0.d0,hh+hh,d1,d2,var) - sum
        if (sum.ge.0) stdv(j) = sqrt(sum)
        if (sum.lt.0) stdv(j) = -sqrt(-sum)
c
        np = np+1
        if (pred(j).lt.pmin) pmin = pred(j)
        if (pred(j).gt.pmax) pmax = pred(j)
30    continue
      if (mod(i,10).eq.1) write(*,*) '- output row: ',i
      write(20,33) (pred(j),j=1,nla)
      write(21,33) (stdv(j),j=1,nla)
33    format(50(/,8f9.3))
35    continue
c
      write(*,50) np,pmin,pmax
50    format(' - Predicted:', i5,' points, min max = ',2f12.5)
      end
c
      real*8 function covp(ki1,ki2,x,y,zz,d1,d2,var)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                         C O V P 
c
c  function for computation of self-consistent covariance functions
c  for geoid undulations, deflections of the vertical and gravity
c  anomalies, using planar logaritmic covariance functions. 
c  these covariance functions features very good fits to empirical
c  covariance functions, the main decay of the power spectrum 
c  corresponding to kaula's rule.
c
c
c  parameters:
c
c  ki1, ki2    kind of quantities (1: geoid undulations,
c              (3: gravity, 6: N-S deflection, 7: E-W deflection)
c
c  x, y        coordinate differences x2-x1, y2-y1 in kilometer
c              (x positive to the east, y to the north)
c
c  zz          = h1 + h2, sum of heights of points in meter
c
c  d1          depth to top layer (km) - high freq. attenuation
c              (twice the'bjerhammar sphere depth')
c
c  d2          thickness to bottom layer (km) - low freq. attenuation
c
c  var         gravity anomaly variance in mgal
c
c  covariances are output in units  mgal**2, mgal*m or m**2.
c  deflections are given as horizontal gravity in mgal,
c  1 arcsec = 4.85 mgal.
c
c  note: double precision is probably needed on machines
c  with short floating point numbers (e.g. ibm)
c
c  programmer: rene forsberg, danish geodetic institute, feb 1986
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h, o-z)
c
      d12 = d1+d2
      d13 = d1+2*d2
      d14 = d1+3*d2
      fc = var/log(d12**3/d13**3*d14/d1)
      zkm = zz/1000
      if (ki1.eq.3.and.ki2.eq.3) goto 20
c
      covp = fc*(plc(ki1,ki2,x,y,d1+zkm)
     *          -3*plc(ki1,ki2,x,y,d12+zkm)
     *          +3*plc(ki1,ki2,x,y,d13+zkm)
     *            -plc(ki1,ki2,x,y,d14+zkm))
      return
c
c  faster computation for gravity autocovariance
c
20    z1 = d1+zkm
      z2 = d12+zkm
      z3 = d13+zkm
      z4 = d14+zkm
      s = x**2 + y**2
      r1 = sqrt(s + z1**2)
      r2 = sqrt(s + z2**2)
      r3 = sqrt(s + z3**2)
      r4 = sqrt(s + z4**2)
      covp = fc*log((z2+r2)**3/(z3+r3)**3*(z4+r4)/(z1+r1))
      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      real*8 function plc(ki1,ki2,x,y,z)
      implicit real*8 (a-h, o-z)
c
c  computes basic cross- and auto covariance components 
c  corresponding to  c(gg) = -log(z + r)
c  
      r = sqrt(x**2 + y**2 + z**2)
c
c  table for various kinds 
c
      goto (11, 12, 12, 9, 9, 13, 14,
     *      12, 15, 15, 9, 9, 16, 17,
     *      12, 15, 15, 9, 9, 16, 17,
     *       9,  9,  9, 9, 9,  9,  9,
     *       9,  9,  9, 9, 9,  9,  9,
     *     131,161,161, 9, 9, 18, 19,
     *     141,171,171, 9, 9, 19, 20), (ki1-1)*7+ki2
9     plc = 0
      stop '*** illegal cov codes in pcov'
c
c  geoid * geoid
c
11    plc = .0000010404d0*(.75*z*r + (.25*r**2-.75*z**2)*log(z+r))
      return
c
c  geoid * gravity, ksi, eta (mgal*meter)
c
12    plc = -.00102*(r - z*log(z+r))
      return
13    plc = -.00051*y*(log(z+r) + .5 + z/(z+r))
      return
131   plc =  .00051*y*(log(z+r) + .5 + z/(z+r))
      return
14    plc = -.00051*x*(log(z+r) + .5 + z/(z+r))
      return
141   plc =  .00051*x*(log(z+r) + .5 + z/(z+r))
      return
c
c  gravity covariance
c
15    plc = -log(z + r)
      return
c
c  gravity/deflection cross covariances
c
16    plc = y/r*(1 - z/(z+r))
      return
161   plc =-y/r*(1 - z/(z+r))
      return
17    plc = x/r*(1 - z/(z+r))
      return
171   plc =-x/r*(1 - z/(z+r))
      return
c
c  deflection auto- and cross covariances
c
18    plc = -.5*(log(z+r) + .5 + z/(z+r) + y**2/(z+r)**2)
      return
19    plc = -.5*x*y/(z+r)**2
      return
20    plc = -.5*(log(z+r) + .5 + z/(z+r) + x**2/(z+r)**2)
      return
      end
c
      subroutine chol(c,n,nsing,imode)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                      C H O L
c
c  subroutine solves positive definite symmetric linear equations
c  using cholesky decomposition. coefficients stored columnwise
c  in c, followed by righthand side. n is number of unknowns.
c  solution is returned as last column in c.
c  'nsing' is number of singularities. it should be zero for a 
c  succesful solution.
c  
c  special entry points (imode):
c
c  1    normal cholesky equation solver
c  
c  2    performs factorization of c without r.h.s.
c
c  3    factors and solves a particular r.h.s., the
c       r.h.s. is stored and the solution returned
c       in the last column of c, i.e. starting with 
c       element c(n*(n+1)/2 + 1). nsing is not used.
c
c  rf, nov 85. modified jan 86.
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      dimension c(*)
c
c  imode: 1: chol, 2: cholfa, 3: cholsl
c
      goto (10,11,12),imode
c
10    nr1 = 1
      nr2 = n+1
      goto 15
c
11    nr1 = 1
      nr2 = n
      goto 15
c
12    nr1 = n+1
      nr2 = n+1
15    if (imode.ne.3) nsing = 0
c
      do 50 nr = nr1, nr2
        i=nr*(nr-1)/2
        ir=i
        do 40 nc = 1,nr
          sum=0
          ic=nc*(nc-1)/2
          i=i+1
          nc1=nc-1
          do 30 np = 1,nc1
30        sum = sum - c(ir+np)*c(ic+np)
          ci = c(i)+sum
          if (nr.eq.nc) goto 31
          c(i) = ci/c(ic+nc)
          goto 40
31        if (nr.gt.n) goto 40
          if (ci.gt.0) goto 32
            nsing = nsing+1
            c(i) = 9.9d39
            goto 40
32        c(i) = sqrt(ci)
40      continue
50    continue
      if (imode.eq.2) return
c
c  back substitution
c
      do 80 nc = n,1,-1
        i=i-1
        ir=i
        ic=nc*(nc+1)/2
        c(i) = c(i)/c(ic)
        do 70 np = nc-1,1,-1
          ir=ir-1
          ic=ic-1
          c(ir) = c(ir) - c(i)*c(ic)
70      continue
80    continue
      return
      end
